/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBType;
import adql.parser.ParseException;
import adql.query.operand.ADQLOperand;
import adql.query.operand.function.ADQLFunction;
import adql.query.operand.function.UserDefinedFunction;
import java.lang.reflect.Constructor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionDef
implements Comparable<FunctionDef> {
    protected static final String regularIdentifierRegExp = "[a-zA-Z]+[0-9a-zA-Z_]*";
    protected static final String typeRegExp = "([a-zA-Z]+[0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?";
    protected static final String fctParamsRegExp = "\\s*[^,]+\\s*(,\\s*[^,]+\\s*)*";
    protected static final String fctParamRegExp = "\\s*([a-zA-Z]+[0-9a-zA-Z_]*)\\s+([a-zA-Z]+[0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?\\s*";
    protected static final String fctDefRegExp = "\\s*([a-zA-Z]+[0-9a-zA-Z_]*)\\s*\\(([a-zA-Z0-9,() \r\n\t]*)\\)(\\s*->\\s*(([a-zA-Z]+[0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?))?\\s*";
    protected static final Pattern fctPattern = Pattern.compile("\\s*([a-zA-Z]+[0-9a-zA-Z_]*)\\s*\\(([a-zA-Z0-9,() \r\n\t]*)\\)(\\s*->\\s*(([a-zA-Z]+[0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?))?\\s*");
    protected static final Pattern paramPattern = Pattern.compile("\\s*([a-zA-Z]+[0-9a-zA-Z_]*)\\s+([a-zA-Z]+[0-9a-zA-Z]*)(\\(\\s*([0-9]+)\\s*\\))?\\s*");
    public final String name;
    public String description = null;
    public final DBType returnType;
    protected final boolean isString;
    protected final boolean isNumeric;
    protected final boolean isGeometry;
    public final int nbParams;
    protected final FunctionParam[] params;
    private final String serializedForm;
    private final String compareForm;
    private Class<? extends UserDefinedFunction> udfClass = null;

    public FunctionDef(String string) {
        this(string, null, null);
    }

    public FunctionDef(String string, DBType dBType) {
        this(string, dBType, null);
    }

    public FunctionDef(String string, FunctionParam[] functionParamArray) {
        this(string, null, functionParamArray);
    }

    public FunctionDef(String string, DBType dBType, FunctionParam[] functionParamArray) {
        if (string == null) {
            throw new NullPointerException("Missing name! Can not create this function definition.");
        }
        this.name = string;
        this.params = functionParamArray == null || functionParamArray.length == 0 ? null : functionParamArray;
        this.nbParams = functionParamArray == null ? 0 : functionParamArray.length;
        this.returnType = dBType;
        if (dBType != null) {
            this.isNumeric = dBType.isNumeric();
            this.isString = dBType.isString();
            this.isGeometry = dBType.isGeometry();
        } else {
            this.isGeometry = false;
            this.isString = false;
            this.isNumeric = false;
        }
        StringBuffer stringBuffer = new StringBuffer(this.name);
        StringBuffer stringBuffer2 = new StringBuffer(this.name.toLowerCase());
        stringBuffer.append('(');
        for (int i = 0; i < this.nbParams; ++i) {
            stringBuffer.append(functionParamArray[i].name).append(' ').append(functionParamArray[i].type);
            stringBuffer2.append(functionParamArray[i].type.isNumeric() ? (char)'1' : '0').append(functionParamArray[i].type.isString() ? (char)'1' : '0').append(functionParamArray[i].type.isGeometry() ? (char)'1' : '0');
            if (i + 1 >= this.nbParams) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(')');
        if (dBType != null) {
            stringBuffer.append(" -> ").append(dBType);
        }
        this.serializedForm = stringBuffer.toString();
        this.compareForm = stringBuffer2.toString();
    }

    public final boolean isNumeric() {
        return this.isNumeric;
    }

    public final boolean isString() {
        return this.isString;
    }

    public final boolean isGeometry() {
        return this.isGeometry;
    }

    public final int getNbParams() {
        return this.nbParams;
    }

    public final FunctionParam getParam(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.nbParams) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.params[n];
    }

    public final Class<? extends UserDefinedFunction> getUDFClass() {
        return this.udfClass;
    }

    public final <T extends UserDefinedFunction> void setUDFClass(Class<T> clazz) throws IllegalArgumentException {
        try {
            Constructor<T> constructor;
            if (clazz != null && (constructor = clazz.getConstructor(ADQLOperand[].class)) == null) {
                throw new IllegalArgumentException("The given class (" + clazz.getName() + ") does not provide any constructor with a single parameter of type ADQLOperand[]!");
            }
            this.udfClass = clazz;
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException("A security problem occurred while trying to get constructor from the class " + clazz.getName() + ": " + securityException.getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("The given class (" + clazz.getName() + ") does not provide any constructor with a single parameter of type ADQLOperand[]!");
        }
    }

    public static FunctionDef parse(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("Missing string definition to build a FunctionDef!");
        }
        Matcher matcher = fctPattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(1);
            DBType dBType = null;
            if (matcher.group(3) != null && (dBType = FunctionDef.parseType(matcher.group(5), matcher.group(7) == null ? -1 : Integer.parseInt(matcher.group(7)))) == null) {
                throw new ParseException("Unknown return type: \"" + matcher.group(4).trim() + "\"!");
            }
            String string3 = matcher.group(2);
            FunctionParam[] functionParamArray = null;
            if (string3 != null && string3.trim().length() > 0) {
                if (!string3.matches(fctParamsRegExp)) {
                    throw new ParseException("Wrong parameters syntax! Expected syntax: \"(<regular_identifier> <type_name> (, <regular_identifier> <type_name>)*)\", where <regular_identifier>=\"[a-zA-Z]+[a-zA-Z0-9_]*\", <type_name> should be one of the types described in the UPLOAD section of the TAP documentation. Examples of good syntax: \"()\", \"(param INTEGER)\", \"(param1 INTEGER, param2 DOUBLE)\"");
                }
                String[] stringArray = string3.split(",");
                functionParamArray = new FunctionParam[stringArray.length];
                for (int i = 0; i < functionParamArray.length; ++i) {
                    DBType dBType2;
                    matcher = paramPattern.matcher(stringArray[i]);
                    if (matcher.matches()) {
                        dBType2 = FunctionDef.parseType(matcher.group(2), matcher.group(4) == null ? -1 : Integer.parseInt(matcher.group(4)));
                        if (dBType2 == null) {
                            throw new ParseException("Unknown type for the parameter \"" + matcher.group(1) + "\": \"" + matcher.group(2) + (matcher.group(3) == null ? "" : matcher.group(3)) + "\"!");
                        }
                    } else {
                        throw new ParseException("Wrong syntax for the " + (i + 1) + "-th parameter: \"" + stringArray[i].trim() + "\"! Expected syntax: \"(<regular_identifier> <type_name> (, <regular_identifier> <type_name>)*)\", where <regular_identifier>=\"[a-zA-Z]+[a-zA-Z0-9_]*\", <type_name> should be one of the types described in the UPLOAD section of the TAP documentation. Examples of good syntax: \"()\", \"(param INTEGER)\", \"(param1 INTEGER, param2 DOUBLE)\"");
                    }
                    functionParamArray[i] = new FunctionParam(matcher.group(1), dBType2);
                }
            }
            return new FunctionDef(string2, dBType, functionParamArray);
        }
        throw new ParseException("Wrong function definition syntax! Expected syntax: \"<regular_identifier>(<parameters>?) <return_type>?\", where <regular_identifier>=\"[a-zA-Z]+[a-zA-Z0-9_]*\", <return_type>=\" -> <type_name>\", <parameters>=\"(<regular_identifier> <type_name> (, <regular_identifier> <type_name>)*)\", <type_name> should be one of the types described in the UPLOAD section of the TAP documentation. Examples of good syntax: \"foo()\", \"foo() -> VARCHAR\", \"foo(param INTEGER)\", \"foo(param1 INTEGER, param2 DOUBLE) -> DOUBLE\"");
    }

    private static DBType parseType(String string, int n) {
        if (string == null) {
            return null;
        }
        try {
            DBType.DBDatatype dBDatatype = DBType.DBDatatype.valueOf(string.toUpperCase());
            n = n <= 0 ? -1 : n;
            switch (dBDatatype) {
                case CHAR: 
                case VARCHAR: 
                case BINARY: 
                case VARBINARY: {
                    return new DBType(dBDatatype, n);
                }
            }
            return new DBType(dBDatatype);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = string.toLowerCase();
            if (string.equals("bool") || string.equals("boolean") || string.equals("short")) {
                return new DBType(DBType.DBDatatype.SMALLINT);
            }
            if (string.equals("int2")) {
                return new DBType(DBType.DBDatatype.SMALLINT);
            }
            if (string.equals("int") || string.equals("int4")) {
                return new DBType(DBType.DBDatatype.INTEGER);
            }
            if (string.equals("long") || string.equals("number") || string.equals("bigint") || string.equals("int8")) {
                return new DBType(DBType.DBDatatype.BIGINT);
            }
            if (string.equals("float") || string.equals("float4")) {
                return new DBType(DBType.DBDatatype.REAL);
            }
            if (string.equals("numeric") || string.equals("float8")) {
                return new DBType(DBType.DBDatatype.DOUBLE);
            }
            if (string.equals("byte") || string.equals("raw")) {
                return new DBType(DBType.DBDatatype.BINARY, n);
            }
            if (string.equals("unsignedByte")) {
                return new DBType(DBType.DBDatatype.VARBINARY, n);
            }
            if (string.equals("character")) {
                return new DBType(DBType.DBDatatype.CHAR, n);
            }
            if (string.equals("string") || string.equals("varchar2")) {
                return new DBType(DBType.DBDatatype.VARCHAR, n);
            }
            if (string.equals("bytea")) {
                return new DBType(DBType.DBDatatype.BLOB);
            }
            if (string.equals("text")) {
                return new DBType(DBType.DBDatatype.CLOB);
            }
            if (string.equals("date") || string.equals("time")) {
                return new DBType(DBType.DBDatatype.TIMESTAMP);
            }
            if (string.equals("position")) {
                return new DBType(DBType.DBDatatype.POINT);
            }
            if (string.equals("polygon") || string.equals("box") || string.equals("circle")) {
                return new DBType(DBType.DBDatatype.REGION);
            }
            return null;
        }
    }

    public String toString() {
        return this.serializedForm;
    }

    @Override
    public int compareTo(FunctionDef functionDef) {
        return this.compareForm.compareTo(functionDef.compareForm);
    }

    @Override
    public int compareTo(ADQLFunction aDQLFunction) {
        if (aDQLFunction == null) {
            throw new NullPointerException("Missing ADQL function with which comparing this function definition!");
        }
        int n = this.name.compareToIgnoreCase(aDQLFunction.getName());
        if (n == 0) {
            for (int i = 0; n == 0 && i < this.nbParams && i < aDQLFunction.getNbParameters(); ++i) {
                if (this.params[i].type.isNumeric() == aDQLFunction.getParameter(i).isNumeric()) {
                    if (this.params[i].type.isString() == aDQLFunction.getParameter(i).isString()) {
                        if (this.params[i].type.isGeometry() == aDQLFunction.getParameter(i).isGeometry()) {
                            n = 0;
                            continue;
                        }
                        n = this.params[i].type.isGeometry() ? 1 : -1;
                        continue;
                    }
                    n = this.params[i].type.isString() ? 1 : -1;
                    continue;
                }
                n = this.params[i].type.isNumeric() ? 1 : -1;
            }
            if (n == 0 && this.nbParams != aDQLFunction.getNbParameters()) {
                n = this.nbParams - aDQLFunction.getNbParameters();
            }
        }
        return n;
    }

    public static final class FunctionParam {
        public final String name;
        public final DBType type;

        public FunctionParam(String string, DBType dBType) {
            if (string == null) {
                throw new NullPointerException("Missing name! The function parameter can not be created.");
            }
            if (dBType == null) {
                throw new NullPointerException("Missing type! The function parameter can not be created.");
            }
            this.name = string;
            this.type = dBType;
        }
    }
}

